<?php
/**
 * WooCommerce Product Sorting by Stock Status
 * Widget for sorting WooCommerce products based on stock status
 */
class SS_Product_Stock_Status extends WP_Widget {

	protected static $instance;

	// Register widget with WordPress.
	function __construct() {
		parent::__construct(
			'ss_product_stock_status', // Base ID
			esc_attr__( 'SS Product Stock Status', 'sswcaf' ), // Name
			array( 'description' => esc_attr__( 'Sort products by stock status', 'sswcaf' ), ) // Args
		);
		self::$instance = false;
	}

	// Front-end display of widget.
	public function widget( $args, $instance ) {

		// Exit if it is not a WooCommerce product archive or shop
		if ( ! ( is_post_type_archive( 'product' ) || is_tax( get_object_taxonomies( 'product' ) ) ) ) {
			return;
		}

		// Exit if widget instance already exists
		if ( ! self::$instance ) {
			self::$instance = true;
		}
		else {
			return;
		}

		$options = get_option( 'sswcaf_settings' );
		if ( isset( $options ) ) {
			$enable_filtering_per_sel = isset( $options['sswcaf_enable_filtering_per_selection'] ) ? $options['sswcaf_enable_filtering_per_selection'] : false;
		}

		$hide_buttons = isset( $instance['buttons'] ) ? $instance['buttons'] : false;

		// Widget output
		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}

		$stock_status		= isset( $_GET['stock_status'] ) ? esc_attr( $_GET['stock_status'] ) : 'all';

		$out = '<ul class="ss-product-stock-status type-radio">';
		$out .= sprintf( '<li%s data-stockstatus="all">%s</li>',
			'all' == $stock_status ? ' class="chosen"' : '',
			esc_attr__( 'All Products', 'sswcaf' )
		);
		$out  .= sprintf( '<li%s data-stockstatus="instock">%s</li>',
			'instock' == $stock_status ? ' class="chosen"' : '',
			esc_attr__( 'In Stock', 'sswcaf' )
		);
		$out .= sprintf( '<li%s data-stockstatus="outofstock">%s</li>',
			'outofstock' == $stock_status ? ' class="chosen"' : '',
			esc_attr__( 'Out of Stock', 'sswcaf' )
		);

		$out .= '</ul>';

		echo $out;

		if ( ! $hide_buttons && ! $enable_filtering_per_sel ) { ?>
			<p class="product-query-buttons">
				<button type="button" class="ss-btn btn-primary apply-query"><?php esc_attr_e( 'Apply', 'sswcaf' ); ?></button><button type="button" class="ss-btn btn-flat reset-sorting"><?php esc_attr_e( 'Reset', 'sswcaf' ); ?></button>
			</p>
		<?php }

		echo $args['after_widget'];
	}

	// Back-end widget form.
	public function form( $instance ) {
		$title		= ! empty( $instance['title'] ) ? $instance['title'] : esc_attr__( 'New title', 'sswcaf' );
		$instance	= wp_parse_args( (array) $instance, array( 'buttons' => false ) );
		?>
		<p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_attr_e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p>
            <input class="checkbox" type="checkbox" <?php checked($instance['buttons'], true) ?> id="<?php echo $this->get_field_id('buttons'); ?>" name="<?php echo $this->get_field_name('buttons'); ?>" />
            <label for="<?php echo $this->get_field_id('buttons'); ?>"><?php esc_attr_e('Hide action buttons'); ?></label>
		</p>
		<?php
	}

	// Sanitize widget form values as they are saved.
	public function update( $new_instance, $old_instance ) {
		$new_instance = (array) $new_instance;
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['buttons'] = isset($new_instance['buttons']) ? true : false;
		return $instance;
	}
}