<?php
/**
 * SS Product Attribute Filters widget
 * Shows available product attributes with a checkbox option
 */

class SS_Product_Attribute_Filters extends WP_Widget {

	// Register widget with WordPress
	function __construct() {
		parent::__construct(
			'ss_product_attribute_filters',
			__( 'SS Product Attribute Filters', 'sswcaf' ),
			array( 'description' => esc_attr__( 'Filter WooCommerce products by attributes', 'sswcaf' ) )
		);
	}

	// Front-end display of widget.
	public function widget( $args, $instance ) {
		//global $_chosen_attributes, $wc_query;

		// Exit if it is not a WooCommerce product archive or shop
		if ( ! ( is_post_type_archive( 'product' ) || is_tax( get_object_taxonomies( 'product' ) ) ) ) {
			return;
		}

		$hide_buttons 		= isset( $instance['buttons'] ) ? $instance['buttons'] : false;
		$attribute 			= isset( $instance['attribute'] ) ? $instance['attribute'] : '';
		$querytype 			= isset( $instance['querytype'] ) ? $instance['querytype'] : 'OR';

		// Arguments for wp_list_categories
		$query_args = array(
			'show_option_all'    => '',
			'orderby'            => 'name',
			'order'              => 'desc',
			'style'              => 'list',
			'show_count'         => 1,
			'hide_empty'         => 1,
			'use_desc_for_title' => 1,
			'child_of'           => 0,
			'feed'               => '',
			'feed_type'          => '',
			'feed_image'         => '',
			'exclude'            => '',
			'exclude_tree'       => '',
			'include'            => '',
			'hierarchical'       => true,
			'title_li'           => null,
			'show_option_none'   => '',
			'number'             => null,
			'echo'               => 0,
			'depth'              => 0,
			'current_category'   => 0,
			'pad_counts'         => 0,
			'taxonomy'           => $attribute,
			'walker' 			 => new SS_Prduct_Filter_Walker,
			'walker_taxonomy' 	 => $attribute,
			'walker_operator' 	 => $querytype,
		);

		if ( ! wp_list_categories( $query_args ) ) {
			return;
		}

		$options = get_option( 'sswcaf_settings' );
		if ( isset( $options ) ) {
			$enable_filtering_per_sel = isset( $options['sswcaf_enable_filtering_per_selection'] ) ? $options['sswcaf_enable_filtering_per_selection'] : false;
		}

		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
		?>

		<ul class="ss-product-attribute-filters type-checkbox" data-taxonomy="<?php echo $attribute; ?>" data-taxnicename="<?php echo str_replace( 'pa_', '', $attribute ); ?>" data-operator="<?php echo $querytype; ?>">
			<?php echo wp_list_categories( $query_args ); ?>
		</ul>

		<?php if ( ! $hide_buttons && ! $enable_filtering_per_sel ) { ?>
			<p class="product-query-buttons">
				<button type="button" class="ss-btn btn-primary apply-query"><?php esc_attr_e( 'Apply', 'sswcaf' ); ?></button><button type="button" class="ss-btn btn-flat reset-atts"><?php esc_attr_e( 'Clear', 'sswcaf' ); ?></button>
			</p>
		<?php }
		echo $args['after_widget'];
	}


	// Back-end widget form
	public function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_attr__( 'New title', 'sswcaf' );
		$instance = wp_parse_args( (array) $instance, array( 'attribute' => '', 'querytype' => 'OR', 'buttons' => false ) );
		?>

		<p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_attr_e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p>
            <label for="<?php echo $this->get_field_id('attribute'); ?>"><?php esc_attr_e( 'Attribute' ); ?></label>

			<?php
            // Generate available product attribute taxonomies to choose from

			$attribute_taxonomies = '';

            if ( function_exists( 'wc_get_attribute_taxonomies' ) ) {
				$attribute_taxonomies = wc_get_attribute_taxonomies();
			}

            $taxonomies = array();

            if ( $attribute_taxonomies ) { ?>
                <select class="widefat" id="<?php echo $this->get_field_id('attribute'); ?>" name="<?php echo $this->get_field_name('attribute'); ?>">
					<?php foreach ( $attribute_taxonomies as $tax ) {
                        $attribute_name	= wc_sanitize_taxonomy_name( $tax->attribute_name );
                        $taxonomies[]	= wc_attribute_taxonomy_name( $attribute_name );
                    }
                    foreach ( $taxonomies as $t ) {
                        echo '<option value="' . $t . '"'
                        . selected( $instance['attribute'], $t, false )
                        . '>' . str_replace( 'pa_', '', $t ) . "</option>\n";
                    } ?>
                </select>
            <?php
            } //if attribute_taxonomies
            else {
				esc_attr_e( 'No attributes found.', 'sswcaf' );
            }
            ?>
		</p>
        <p>
            <label for="<?php echo $this->get_field_id('querytype'); ?>"><?php esc_attr_e( 'Query type' ); ?></label>
            <select name="<?php echo $this->get_field_name('querytype'); ?>" id="<?php echo $this->get_field_id('querytype'); ?>" class="widefat">
                <option value="OR"<?php selected( $instance['querytype'], 'OR' ); ?>><?php esc_attr_e( 'OR' ); ?></option>
                <option value="AND"<?php selected( $instance['querytype'], 'AND' ); ?>><?php esc_attr_e( 'AND' ); ?></option>
            </select>
        </p>
		<p>
            <input class="checkbox" type="checkbox" <?php checked($instance['buttons'], true) ?> id="<?php echo $this->get_field_id('buttons'); ?>" name="<?php echo $this->get_field_name('buttons'); ?>" />
            <label for="<?php echo $this->get_field_id('buttons'); ?>"><?php esc_attr_e('Hide action buttons'); ?></label>
		</p>

	<?php
    }

	// Sanitize widget form values as they are saved
	public function update( $new_instance, $old_instance ) {
		$new_instance = (array) $new_instance;
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['buttons'] = isset($new_instance['buttons']) ? true : false;
		$instance['querytype'] = 'OR';
		if ( in_array( $new_instance['querytype'], array( 'OR', 'AND' ) ) ) {
			$instance['querytype'] = $new_instance['querytype'];
		}

		$instance['attribute'] = $new_instance['attribute'];

		return $instance;
	}
}