<?php
/**
 * Plugin Name:	SS WooCommerce Ajax Filters
 * Author:		SaurabhSharma
 * Author URI:	http://codecanyon.net/user/saurabhsharma
 * Version:		1.6.0
 * Text Domain:	sswcaf
 * Domain Path:	/languages/
 * Description:	Ajax filtering of WooCommerce products.
 */

class SS_WooCommerce_Ajax_Filters {

	function __construct() {
		// Include required files
		add_action( 'plugins_loaded', array( &$this, 'sswcaf_includes' ) );

		// Register widgets
		add_action( 'widgets_init', array(&$this, 'sswcaf_widgets_init') );

		// Load text domain
		add_action( 'init', array(&$this, 'sswcaf_init') );

		// Load scripts and styles
		add_action( 'wp_enqueue_scripts', array(&$this, 'sswcaf_scripts') );
		
	}

	function sswcaf_includes() {
		$plugin_dir = trailingslashit( plugin_dir_path( __FILE__ ) );
		require_once( $plugin_dir . 'includes/ss-wcaf-functions.php' );
		require_once( $plugin_dir . 'includes/ss-wcaf-settings.php' );
		require_once( $plugin_dir . 'widgets/class-ss-product-sorting.php' );
		require_once( $plugin_dir . 'widgets/class-ss-product-price-range.php' );
		require_once( $plugin_dir . 'widgets/class-ss-product-attribute-filters.php' );
		require_once( $plugin_dir . 'widgets/class-ss-product-reset-filters.php' );
		require_once( $plugin_dir . 'widgets/class-ss-product-stock-status.php' );
	}

	function sswcaf_init() {

		// Translation
		load_plugin_textdomain( 'sswcaf', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

		// Disable WooCommerce redirect to single product when there is only one search result
		add_filter( 'woocommerce_redirect_single_search_result', '__return_false' );

		// Remove WooCommerce product sorting dropdown
		remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
		
		// Add Stock Meta Query
		add_filter( 'woocommerce_product_query_meta_query', array( $this, 'sswcaf_stock_status_meta_query' ) );

	}

	function sswcaf_widgets_init() {
		register_widget( 'SS_Product_Sorting' );
		register_widget( 'SS_Product_Price_Range' );
		register_widget( 'SS_Product_Attribute_Filters' );
		register_widget( 'SS_Product_Reset_Filters' );
		register_widget( 'SS_Product_Stock_Status' );
	}
	
	function sswcaf_stock_status_meta_query( $meta_query ) {
		if ( ! is_array( $meta_query ) ) {
			$meta_query = array();
		}
		if ( isset( $_GET['stock_status'] ) ) {
			if ( 'instock' == $_GET['stock_status'] || 'outofstock' == $_GET['stock_status'] ) {
				$meta_query['stock_status'] = array(
					'key' 		=> '_stock_status',
					'value' 	=> esc_html( $_GET['stock_status'] ),
					'compare' 	=> '=',
				);
			}
		}
		
		return $meta_query;
	}

	function sswcaf_scripts() {
		global $wp_rewrite, $post;

		if ( is_post_type_archive( 'product' ) || is_tax( get_object_taxonomies( 'product' ) ) ) {

			//wp_enqueue_style( 'material-icons', '//fonts.googleapis.com/icon?family=Material+Icons', array(), null );
			wp_enqueue_style( 'ss-wcaf-styles', plugin_dir_url( __FILE__ ) . 'assets/css/ss-wcaf-style.css', array(), null );

			if ( is_rtl() ) {
				wp_enqueue_style( 'ss-wcaf-rtl', plugin_dir_url( __FILE__ ) . 'assets/css/ss-wcaf-rtl.css', array(), null );
			}

			// JavaScript files
			wp_enqueue_script( 'ss-wcaf-frontend', plugin_dir_url( __FILE__ ) . 'assets/js/ss-wcaf-frontend.js', array( 'jquery' ), '', true );
		}

		// Localize text strings and variables used in ss-wcaf-frontend.js file
		$permalink_structure = ! empty( $wp_rewrite->permalink_structure ) ? $wp_rewrite->permalink_structure : 'default';
		$options = get_option( 'sswcaf_settings' );
		$template = '';
		$template = get_option( 'template' );
		$container = '#main';
		$sb_container = '#sswcaf-shop-sidebar';

		/**
		 * Detect product and sidebar containers based on known themes.
		 * Most twenty* themes have #main product container.
		 */

		if ( 'twentyeleven' == $template || 'twentytwelve' == $template || 'twentythirteen' == $template ) {
			$container = '#content';
		}

		if ( 'twentysixteen' == $template ) {
			$sb_container = '#secondary.sidebar';
		}

		if ( 'twentyfifteen' == $template ) {
			$sb_container = '#widget-area';
		}

		if ( 'twentyfourteen' == $template ) {
			$container = '.tfwc';
			$sb_container = '#primary-sidebar.widget-area';
		}

		if ( 'twentythirteen' == $template ) {
			$sb_container = '#secondary .widget-area';
		}

		if ( isset( $options ) ) {
			$prod_container 				= ! empty( $options['sswcaf_prod_container'] ) ? $options['sswcaf_prod_container'] : $container;
			$sb_container 					= ! empty( $options['sswcaf_sb_container'] ) ? $options['sswcaf_sb_container'] : '#sswcaf-shop-sidebar';
			$enable_session 				= isset( $options['sswcaf_enable_session'] ) ? $options['sswcaf_enable_session'] : false;
			$enable_filtering_per_sel 		= isset( $options['sswcaf_enable_filtering_per_selection'] ) ? $options['sswcaf_enable_filtering_per_selection'] : false;
			$custom_preloader 				= ! empty( $options['sswcaf_preloader'] ) ? $options['sswcaf_preloader'] : false;
		}

		// Tell JS if the browser is Internet Explorer
		$ie_check = preg_match( '/MSIE/i', $_SERVER['HTTP_USER_AGENT'] ) ? true : false;

		$localization = array(
			'permalink_structure'			=> $permalink_structure,
			'prod_container'				=> $prod_container,
			'sb_container' 					=> $sb_container,
			'disable_ajax_loadmore' 		=> apply_filters( 'sswcaf_disable_loadmore', false ),
			'enable_session'				=> $enable_session,
			'enable_filtering_per_sel'		=> $enable_filtering_per_sel,
			'no_products_found' 			=> esc_attr__( 'No products found matching your query.', 'sswcaf' ),
			'no_products_left' 				=> esc_attr__( 'No more products to show.', 'sswcaf' ),
			'loading' 						=> esc_attr__( 'Loading...', 'sswcaf' ),
			'view_more'						=> esc_attr__( 'View More' , 'sswcaf' ),
			'not_loaded'					=> esc_attr_x( 'The products could not be loaded. Error: ', 'used errortype at end', 'sswcaf' ),
			'ie_check'						=> $ie_check,
			'custom_preloader'				=> $custom_preloader,
			'ajax_timeout'					=> apply_filters( 'sswcaf_ajax_timeout', '30000' )
		);

		wp_localize_script( 'ss-wcaf-frontend', 'ss_wcaf_localize', $localization );
	}
}

$ss_woocommerce_ajax_filters = new SS_WooCommerce_Ajax_Filters();
?>