<?php
/**
 * SS WooCommerce Ajax Fiters Admin Settings
 */

add_action( 'admin_menu', 'sswcaf_add_admin_menu' );
add_action( 'admin_init', 'sswcaf_settings_init' );


// Add options page
function sswcaf_add_admin_menu() {
	add_options_page( 'SS WooCommerce Ajax Filters', 'SS WooCommerce Ajax Filters', 'manage_options', 'sswcaf', 'sswcaf_options_page' );

}

// Plugin settings init
function sswcaf_settings_init(  ) {

	register_setting( 'pluginPage', 'sswcaf_settings' );

	add_settings_section(
		'sswcaf_pluginPage_section',
		esc_attr__( 'Plugin Settings', 'sswcaf' ),
		'',
		'pluginPage'
	);

	add_settings_field(
		'sswcaf_prod_container',
		esc_attr__( 'Products Container Selector', 'sswcaf' ),
		'sswcaf_prod_container_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);


	add_settings_field(
		'sswcaf_sb_container',
		esc_attr__( 'Sidebar Container Selector', 'sswcaf' ),
		'sswcaf_sb_container_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);

	add_settings_field(
		'sswcaf_select_sidebar',
		__( 'Choose sidebar for mobile filters', 'sswcaf' ),
		'sswcaf_select_sidebar_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);

	add_settings_field(
		'sswcaf_preloader',
		esc_attr__( 'Custom preloader HTML', 'sswcaf' ),
		'sswcaf_preloader_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);

	add_settings_field(
		'sswcaf_enable_filtering_per_selection',
		esc_attr__( 'Enable filtering per selection', 'sswcaf' ),
		'sswcaf_enable_filtering_per_selection_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);	

	add_settings_field(
		'sswcaf_enable_session',
		esc_attr__( 'Enable Session Storage', 'sswcaf' ),
		'sswcaf_enable_session_render',
		'pluginPage',
		'sswcaf_pluginPage_section'
	);

}

/**
 * Render plugin setting fields
 */

function sswcaf_prod_container_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$value = isset($options['sswcaf_prod_container']) ? $options['sswcaf_prod_container'] : '';
	?>
	<input type='text' name='sswcaf_settings[sswcaf_prod_container]' value='<?php echo $value; ?>'>
    <p class="description"><?php esc_attr_e( 'Provide ID or class name of the main container in which WooCommerce products are shown. For example: #main', 'sswcaf' ); ?></p>
	<?php

}

function sswcaf_preloader_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$value = isset($options['sswcaf_preloader']) ? $options['sswcaf_preloader'] : '';
	?>
	<textarea name='sswcaf_settings[sswcaf_preloader]' cols="40" rows="6"><?php echo $value; ?></textarea>
    <p class="description"><?php esc_attr_e( 'Provide custom preloader HTML if you do not wish to use built in preloader.', 'sswcaf' ); ?></p>
	<?php

}

function sswcaf_sb_container_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$value = isset($options['sswcaf_sb_container']) ? $options['sswcaf_sb_container'] : '';
	?>
	<input type='text' name='sswcaf_settings[sswcaf_sb_container]' value='<?php echo $value; ?>'>
    <p class="description"><?php esc_attr_e( 'Provide ID or class name of widget area container in which filter widgets are placed. For example: #sidebar', 'sswcaf' ); ?></p>
	<?php

}

function sswcaf_enable_filtering_per_selection_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$checked = isset( $options['sswcaf_enable_filtering_per_selection'] ) ? $options['sswcaf_enable_filtering_per_selection'] : false;
	?>
	<input type='checkbox' id = "sswcaf_settings[sswcaf_enable_filtering_per_selection]" name='sswcaf_settings[sswcaf_enable_filtering_per_selection]' <?php checked( $checked, 1 ); ?> value='1'>
    <label for="sswcaf_settings[sswcaf_enable_filtering_per_selection]"><?php esc_attr_e( 'Check to enable filtering per selection.', 'sswcaf' ); ?></label>
    <p class="description"><?php esc_attr_e( 'Upon enabling this feature, ajax results will be shown as user clicks on filters. The Apply button will be disabled.', 'sswcaf' ); ?></p>
	<?php
}

function sswcaf_enable_session_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$checked = isset( $options['sswcaf_enable_session'] ) ? $options['sswcaf_enable_session'] : false;
	?>
	<input type='checkbox' id = "sswcaf_settings[sswcaf_enable_session]" name='sswcaf_settings[sswcaf_enable_session]' <?php checked( $checked, 1 ); ?> value='1'>
    <label for="sswcaf_settings[sswcaf_enable_session]"><?php esc_attr_e( 'Check to enable Session Storage.', 'sswcaf' ); ?></label>
    <p class="description"><?php esc_attr_e( 'Session storage in this plugin is used for saving page results of ajax load-more. Saved results are served if the same query is generated again.', 'sswcaf' ); ?></p>

    <p class="description"><?php esc_attr_e( 'Please be aware that this feature is in beta phase, and is not supported on all browsers. If you encounter any issue using this feature, kindly uncheck session storage and report the issue to me at xconsau[at]gmail[dot]com.', 'sswcaf' ); ?></p>
	<?php

}

function sswcaf_select_sidebar_render(  ) {

	$options = get_option( 'sswcaf_settings' );
	$sswcaf_select_sidebar = isset( $options['sswcaf_select_sidebar'] ) ? $options['sswcaf_select_sidebar'] : null;
	global $wp_registered_sidebars;

    if ( empty( $wp_registered_sidebars ) ) {
        esc_attr_e( 'No registered sidebars found.', 'sswcaf' );
		return;
	}
    ?>
    <select name='sswcaf_settings[sswcaf_select_sidebar]'>
    <?php foreach ( $wp_registered_sidebars as $sidebar ) : ?>
        <option value="<?php echo esc_attr( $sidebar['id'] ); ?>"<?php selected( $sswcaf_select_sidebar, $sidebar['id'] ); ?>><?php echo $sidebar['name']; ?></option>
    <?php endforeach; ?>
    </select>

    <p class="description"><?php esc_attr_e( 'This sidebar will show as sliding sidebar on mobile. It should be the one in which you have placed filter widgets.', 'sswcaf' ); ?></p>
    <?php
}

// Generate settings form
function sswcaf_options_page(  ) { ?>
    <div class="wrap">
        <form action='options.php' method='post'>
            <h1>SS WooCommerce Ajax Filters</h1>
            <hr />
            <?php
            settings_fields( 'pluginPage' );
            do_settings_sections( 'pluginPage' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}
?>