/**
 * ss-wcaf-frontend.js
 *
 * @author SaurabhSharma
 * @since 1.0.0
 * @version 1.6.0
 */

// Material design style loading spinner
var sswcaf_spinner = '<div class="md-loader"><svg class="spinner" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg"><g transform="translate(33, 33)"><circle class="myObject" stroke="#000" fill="none" stroke-linecap="round" stroke-width="5" x="-10" y="-10" r="20"></circle></g></svg></div>';

// Add gif preloader for IE
if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.ie_check) {
    sswcaf_spinner = '<div class="md-loader gif-enabled"></div>';
}

// Use custom preloader if defined by user in plugin settings
if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.custom_preloader) {
    sswcaf_spinner = ss_wcaf_localize.custom_preloader;
}

if (!window.location.origin) {
    window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
}

jQuery(function ($) {

    'use strict';

    // Set global timeout for ajax calls
    $.ajaxSetup({
        timeout: (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.ajax_timeout) ? ss_wcaf_localize.ajax_timeout : 30000
    });

    // Set global variables used in this file
    var ss_prod_container = (ss_wcaf_localize !== 'undefined') ? ss_wcaf_localize.prod_container : '#main',
        ss_sb_container = (ss_wcaf_localize !== 'undefined') ? ss_wcaf_localize.sb_container : '#sswcaf-shop-sidebar',
        enableSession = (ss_wcaf_localize !== 'undefined') ? ss_wcaf_localize.enable_session : false;

    // Check and load any saved session for current URL
    $(window).on('load', function () {
        var current_url = window.location.origin + window.location.pathname + window.location.search,
            tData = [];

        if (enableSession && sessionStorage && sessionStorage.getItem('sessionData')) {
            tData.length = 0;
            tData = $.parseJSON(sessionStorage.getItem('sessionData'));
            $.map(tData, function (obj) {
                if (obj.url === current_url) {
                    $(ss_prod_container).html(obj.productHTML);
                    $(ss_sb_container).html(obj.widgetHTML);
                    $(document).trigger('session-loaded');
                }
            });
        }

    });

    // Enable ajax loadmore on first load
    $(document).on('ready', function () {
        if (ss_wcaf_localize !== 'undefined' && !ss_wcaf_localize.disable_ajax_loadmore) {
            ajaxLoadMore();
        }
    });

    // Wrap main content area in custom container
    $(ss_prod_container).wrapInner("<div class='ss-wcaf-container'></div>");


    // Enable click toggle on check style list
    $(document).on('click', 'ul.type-checkbox > li > a', function (e) {
        e.preventDefault();
        $(this).off('click');
        $(this).parent('li').toggleClass('chosen');
        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.enable_filtering_per_sel) {
            ss_wcaf_generate_query();
			$(ss_sb_container).removeClass('side-panel-active');
			$('.panel-body-mask').removeClass('show-mask');
			$('#sliding-panel-actions').removeClass('active-toggle');
        }
    });

    // Enable click toggle on radio style list
    $(document).on('click', 'ul.ss-product-sorting > li, ul.ss-product-price-range > li, ul.ss-product-stock-status > li', function (e) {
        e.preventDefault();
        $(this).off('click');
        $(this).parent().find('li').removeClass('chosen');
        $(this).addClass('chosen');
        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.enable_filtering_per_sel) {
            ss_wcaf_generate_query();
			$(ss_sb_container).removeClass('side-panel-active');
			$('.panel-body-mask').removeClass('show-mask');
			$('#sliding-panel-actions').removeClass('active-toggle');			
        }
    });

    // Reset check lists
    $(document).on('click', 'button.reset-atts, button.reset-cats, button.clear-price-range', function (e) {
        e.preventDefault();
        $(this).off('click');
        $(this).parent().parent().find('li').removeClass('chosen');
        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.enable_filtering_per_sel) {
            ss_wcaf_generate_query();
        }
    });

    // Reset sorting list
    $(document).on('click', 'button.reset-sorting', function (e) {
        e.preventDefault();
        $(this).off('click');
        $(this).parent().parent().find('ul.type-radio > li').removeClass('chosen');
        //if ($('ul.ss-product-sorting').length > 0) {
        $(this).parent().parent().find('ul.type-radio > li:first-child').addClass('chosen');
        //}
        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.enable_filtering_per_sel) {
            ss_wcaf_generate_query();
        }
    });

    // Reset All button
    $(document).on('click', 'button.reset-all', function (e) {
        e.preventDefault();
        $(this).off('click');
        $('ul.ss-product-attribute-filters > li, ul.type-radio > li, ul.ss-product-price-range > li').removeClass('chosen');
        $('ul.ss-product-stock-status > li:first-child, ul.ss-product-sorting > li:first-child').addClass('chosen');
        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.enable_filtering_per_sel) {
            ss_wcaf_generate_query();
        }
    });

    // Apply Query button
    $(document).on('click', 'p.product-query-buttons button.apply-query', function (e) {
        e.preventDefault();
        $(this).off('click');
        $(ss_sb_container).removeClass('side-panel-active');
        $('.panel-body-mask').removeClass('show-mask');
        $('#sliding-panel-actions').removeClass('active-toggle');
        ss_wcaf_generate_query();
    });

    // Filter query generator
    function ss_wcaf_generate_query() {

        var chosen_attributes = [],
            att_taxonomies = [],
            widget_ids = [],
            orderby = 'menu_order',
            orderby_string = '',
            stockstatus = 'all',
            stockstatus_string,
            attribute_widgets = $('ul.ss-product-attribute-filters'),
            att_query_string = '',
            base_url = window.location.origin + window.location.pathname,
            is_search = false,
            is_cat = false,
            is_tag = false,
            href = window.location.href,
            query_string = '',
            min_price = 0,
            max_price = 0,
            price_query = '',
            delim = '?',
            amp = '',
            error,
            pageTitle,
            tData = [],
            nextLink,
            no_products_found = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.no_products_found : 'No products found matching your query.',
            not_loaded = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.not_loaded : 'The products could not be loaded. Error: ',
            replaced = false;

        // Add loading spinner
        if ($('.ss-wcaf-container').length) {
            $(sswcaf_spinner).addClass('products-loader').appendTo('.ss-wcaf-container');
            $('.ss-wcaf-container .products, .woocommerce-result-count, #ss-ajax-loadmore-actions').animate({
                opacity: 0.3
            });
        }

        // Find attribute terms in widgets
        if (attribute_widgets && attribute_widgets.length > 0) {
            attribute_widgets.each(function () {
                var att_items = $(this).find('li.chosen').children('a'),
                    att_taxonomy = $(this).data('taxonomy'),
                    att_operator = $(this).data('operator'),
                    att_terms = [],
                    op_trail,
                    tax_nice_name,
                    query_per_widget = '';
                if (att_taxonomy) {
                    tax_nice_name = att_taxonomy.replace('pa_', '');
                }
                if (att_items.length > 0) {
                    query_per_widget = 'filter_' + tax_nice_name + '=';
                    op_trail = 'OR' === att_operator ? '&query_type_' + tax_nice_name + '=or' : '';
                    att_items.each(function () {
                        att_terms.push($(this).data('slug'));
                    });
                    query_per_widget += att_terms.join('%2C') + op_trail;
                }
                if (query_per_widget) {
                    chosen_attributes.push(query_per_widget);
                }
                widget_ids.push($(this).parent().attr('id'));
                att_taxonomies.push(att_taxonomy);

            });

            // Attribute Parameters
            if (chosen_attributes.length > 1) {
                att_query_string = chosen_attributes.join('&');
            } else {
                att_query_string = chosen_attributes[0];
            }
        }


        // Orderby parameters
        if ($('ul.ss-product-sorting').length > 0) {
            orderby = $('ul.ss-product-sorting').find('li.chosen').data('orderby');
            orderby_string = (orderby !== 'menu_order') ? 'orderby=' + orderby : '';
        }

        // Stock Status parameters
        if ($('ul.ss-product-stock-status').length > 0) {
            stockstatus = $('ul.ss-product-stock-status').find('li.chosen').data('stockstatus');
            stockstatus_string = (stockstatus !== 'all') ? 'stock_status=' + stockstatus : '';
        }

        // Price range parameters
        if ($('ul.ss-product-price-range').length > 0) {
            min_price = $('ul.ss-product-price-range').find('li.chosen').data('minprice');
            max_price = $('ul.ss-product-price-range').find('li.chosen').data('maxprice');

            if (min_price > 0) {
                price_query = 'min_price=' + min_price;
                if (max_price > 0 && max_price > min_price) {
                    price_query += '&max_price=' + max_price;
                }
            }

            if (min_price <= 0 && max_price > 0) {
                price_query = 'max_price=' + max_price;
            }
        }


        // Build Query

        // Check if it is a search page
        is_search = getParameterByName('s');

        // If permalink structure is default
        if (!is_search && ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.permalink_structure === 'default') {

            is_cat = getParameterByName('product_cat');

            is_tag = getParameterByName('product_tag');

            if (is_cat) {
                base_url = base_url + '?product_cat=' + is_cat;
            } else if (is_tag) {
                base_url = base_url + '?product_tag=' + is_tag;
            } else {
                base_url = base_url + '?post_type=product';
            }

            delim = '&';
        }

        if (is_search) {
            delim = window.location.search;

            // Remove all parameters except search
            $(att_taxonomies).each(function () {
                delim = remove_param(delim, this);
            });
            delim = remove_param(delim, 'orderby');
            delim = remove_param(delim, 'min_price');
            delim = remove_param(delim, 'max_price');
            delim = remove_param(delim, 'stock_status');
            amp = '&';
        }

        if (att_query_string) {

            query_string = delim + amp + att_query_string;

            if (orderby !== 'menu_order') {
                query_string += '&' + orderby_string;
            }

            if (stockstatus !== 'all') {
                query_string += '&' + stockstatus_string;
            }

            if (price_query) {
                query_string += '&' + price_query;
            }
        }

        if (!att_query_string && orderby !== 'menu_order') {
            query_string = delim + amp + orderby_string;

            if (stockstatus !== 'all') {
                query_string += '&' + stockstatus_string;
            }

            if (price_query) {
                query_string += '&' + price_query;
            }
        }

        if (!att_query_string && orderby === 'menu_order' && stockstatus !== 'all') {
            query_string = delim + amp + stockstatus_string;

            if (price_query) {
                query_string += '&' + price_query;
            }
        }

        if (!att_query_string && orderby === 'menu_order' && stockstatus === 'all' && price_query) {
            query_string = delim + amp + price_query;
        }

        // Keep current URL if it is a search
        // and no filters are chosen
        if (is_search && !query_string) {
            if (is_search === 'none') {
                query_string = '?s=&post_type=product';
            } else {
                query_string = '?s=' + is_search + '&post_type=product';
            }
        }

        // Final query URL
        href = base_url + query_string;

        // Remove page/xx/ or paged=xx from URL
        // When AJAX loadmore is diabled, it will generate proper query
        if ((ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.permalink_structure === 'default') || window.location.search) {
            href = href.replace(/\paged\=\d+/, '');
        } else {
            href = href.replace(/\/page\/\d+/, '');
        }


        // Check if any previusly saved session is available
        // If so, load it and do not make an ajax call
        if (enableSession && sessionStorage && sessionStorage.getItem('sessionData')) {
            tData.length = 0;
            tData = $.parseJSON(sessionStorage.getItem('sessionData'));

            $.map(tData, function (obj) {
                if (obj.url === href) {
                    $(ss_prod_container).html(obj.productHTML);
                    $(ss_sb_container).html(obj.widgetHTML);
                    if (history.pushState) {
                        history.pushState({}, '', href);
                    }
                    $(document).trigger('session-loaded');
                    replaced = true;

                    $('.ss-wcaf-container .products, .woocommerce-result-count, #ss-ajax-loadmore-actions').animate({
                        opacity: 1
                    });
                    $('.ss-wcaf-container').find('.products-loader').fadeOut().remove();
                }
            });
        }

        $.support.cors = true;

        if (!replaced) {
            // Load products via ajax
            $.ajax({
                url: href,
                timeout: 30000,
                cache: false,
                crossDomain: true,
                error: function (xhr) {
                    var errormsg = (xhr.status === 404) ? no_products_found : not_loaded + xhr.statusText;
                    $('.ss-wcaf-container .products, .woocommerce-result-count, #ss-ajax-loadmore-actions').animate({
                        opacity: 1
                    });
                    $(ss_prod_container + ' .ss-wcaf-container').find('p.woocommerce-result-count, .products, #ss-ajax-loadmore-actions, div.ss-snackbar').remove();
                    $(ss_prod_container + ' .ss-wcaf-container').append('<div class="ss-snackbar">' + errormsg + '</div>');

                    $('.ss-wcaf-container').find('.products-loader').fadeOut().remove();
                    return;
                },
                success: function (response) {

                    // Replace response html in container
                    if ($(response).find(ss_prod_container).length > 0) {

                        $(ss_prod_container + ' .ss-wcaf-container').html($(response).find(ss_prod_container).html());
                    }

                    $('.ss-wcaf-container .products, .woocommerce-result-count, #ss-ajax-loadmore-actions').animate({
                        opacity: 1
                    });

                    $('.ss-wcaf-container').find('.products-loader').fadeOut().remove();


                    // Check if no products were found
                    error = $(response).find('.woocommerce-info');

                    // Update widgets only if some products are found
                    if (!error.length) {
                        $(widget_ids).each(function () {
                            var t = this;
                            if ($(response).find('#' + t).text()) {
                                $('#' + t).html($(response).find('#' + t).html()).show();
                            } else {
                                $('#' + t).hide();
                                $('.widget_ss_product_sorting').hide();
                            }

                        });
                    }

                    // Update browser URL
                    if (history.pushState) {
                        pageTitle = $(response).find("title").text();
                        history.pushState({}, pageTitle, href);
                    }


                    // Call loadmore function
                    if (ss_wcaf_localize !== 'undefined' && !ss_wcaf_localize.disable_ajax_loadmore) {
                        // Create next link for ajax loadmore
                        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.permalink_structure === 'default') {
                            nextLink = href + '&paged=2';
                        } else {
                            nextLink = window.location.search ? href + '&paged=2' : window.location.origin + window.location.pathname + 'page/2/';
                        }

                        ajaxLoadMore(href, nextLink);
                    }

                    // Trigger after load event
                    $(document).trigger("ss-wcaf-ajax-filtered");

                }
            });

        }
    }


    // AJAX load more
    function ajaxLoadMore(href, nextLink) {

        if (!window.location.origin) {
            window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
        }

        var pageNum = 2,
            maxPages,
            current_url = href ? href : window.location.origin + window.location.pathname + window.location.search,
            params = $('#ajax-loadmore-data').data('localization'),
            first,
            last,
            total,
            resultText,
            new_result,
            sData = [],
            tempData = [],
            view_more = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.view_more : 'View more',
            no_products_left = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.no_products_left : 'No more products to show.',
            loading_text = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.loading : 'Loading...';

        // Create nextpage link if not set yet
        if (!nextLink) {
            if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.permalink_structure === 'default') {
                nextLink = current_url + '&paged=2';
            } else {
                nextLink = window.location.search ? current_url + '&paged=2' : window.location.origin + window.location.pathname + 'page/2/';
            }
        }

        // Find paramas like pageNum, maxPages etc. from page source
        if (params) {
            pageNum = params.startPage + 1;
            maxPages = params.maxPages;
            first = (params.perPage * params.startPage) - params.perPage + 1;
            last = Math.min(params.total, params.perPage * params.startPage);
            total = params.total;
            resultText = params.resultText;
        }

        // Hide defaulr pagination
        $('.woocommerce-pagination').hide();

        // Add View More button and data holder
        if (pageNum <= maxPages) {
            $(ss_prod_container + ' .ss-wcaf-container')
                .append('<div class="ss-ajax-posts-holder-' + pageNum + '"></div>')
                .append('<div id="ss-ajax-loadmore-actions"><a class="ss-ajax-load-more-btn ss-btn btn-flat" href="#">' + view_more + '</a></div>');
        }

        // Click event on view more button
        $(ss_prod_container).off().on('click', 'a.ss-ajax-load-more-btn', function (e) {

            e.preventDefault();

            // Check for an updated URL
            current_url = window.location.origin + window.location.pathname + window.location.search;

            // If it was a session data replacement, use variables of the saved state
            if (enableSession && sessionStorage && sessionStorage.getItem('sessionData')) {
                sData.length = 0;
                sData = $.parseJSON(sessionStorage.getItem('sessionData'));

                $.map(sData, function (obj) {
                    if (obj.url === current_url) {
                        pageNum = parseInt(obj.pageNum);
                        maxPages = parseInt(obj.maxPages);
                        nextLink = obj.nextLink;
                    }
                });

            }

            // If there are pages to navigate, proceed
            if (pageNum <= maxPages) {

                // Loading text and spinner
                $(this).text(loading_text);
                $(sswcaf_spinner).addClass('more-loader').appendTo('#ss-ajax-loadmore-actions');

                // ajax load next results
                $('.ss-ajax-posts-holder-' + pageNum).load(nextLink + ' .products',
                    function (status, xhr) {
                        var not_loaded = ss_wcaf_localize !== 'undefined' ? ss_wcaf_localize.not_loaded : 'The products could not be loaded.';
                        if (status == "error" || status == "timeout") {
                            $(ss_prod_container + ' .ss-wcaf-container').append('<div class="ss-snackbar">' + not_loaded + ' ' + xhr.status + ' ' + xhr.statusText + '</div>');

                            $('#ss-ajax-loadmore-actions').remove();
                            return;
                        }

                        // Remove loading spinner
                        $('.more-loader').remove();

                        // Re check for params
                        params = $('#ajax-loadmore-data').data('localization');
                        if (params) {
                            first = (params.perPage * params.startPage) - params.perPage + 1;
                            last = Math.min(params.total, params.perPage * params.startPage);
                            total = params.total;
                            resultText = params.resultText;
                        }

                        // Update result text
                        last = Math.min(params.total, params.perPage * pageNum);
                        new_result = resultText;
                        new_result = new_result.replace('%d', total);
                        new_result = new_result.replace('%1$d', first);
                        new_result = new_result.replace('%2$d', last);
                        new_result = new_result.replace('%3$d', total);

                        $('p.woocommerce-result-count').text(new_result);

                        // Update page number
                        pageNum += 1;

                        // Update nextlink as per new page number
                        if (ss_wcaf_localize !== 'undefined' && ss_wcaf_localize.permalink_structure === 'default') {
                            nextLink = current_url + '&paged=' + pageNum;
                        } else {
                            nextLink = window.location.search ? current_url + '&paged=' + pageNum : window.location.origin + window.location.pathname + 'page/' + pageNum + '/';
                        }

                        // Add new placeholder for next results
                        $('#ss-ajax-loadmore-actions').before('<div class="ss-ajax-posts-holder-' + pageNum + '"></div>');

                        // Update the button text
                        $('a.ss-ajax-load-more-btn').text(view_more);

                        // Update the button text or remove it
                        // depending upon page number
                        if (pageNum <= maxPages) {
                            $('a.ss-ajax-load-more-btn').text(view_more);
                        } else {
                            $('a.ss-ajax-load-more-btn').remove();

                            if (pageNum > 1) {
                                $('#ss-ajax-loadmore-actions').html('<div class="ss-snackbar">' + no_products_left + '</div>');
                            } else {
                                $('#ss-ajax-loadmore-actions').remove();
                            }
                        }

                        $(document).trigger("ss-wcaf-ajax-loaded");

                        // Save page state in Session Storage
                        if (enableSession && sessionStorage) {

                            try {

                                // If the state is saved previously
                                if (sessionStorage.getItem('sessionData')) {

                                    // Remove current URL state
                                    sData.length = 0;
                                    tempData.length = 0;
                                    tempData = $.parseJSON(sessionStorage.getItem('sessionData'));
                                    $.map(tempData, function (obj) {
                                        if (obj.url !== current_url) {
                                            sData.push(obj);
                                        }
                                    });

                                }

                                // Save new state for current URL
                                sData.push({
                                    url: current_url,
                                    pageNum: pageNum,
                                    maxPages: maxPages,
                                    nextLink: nextLink,
                                    productHTML: $(ss_prod_container).html(),
                                    widgetHTML: $(ss_sb_container).html()
                                });

                                // Set the data in Session Storage
                                sessionStorage.setItem('sessionData', JSON.stringify(sData));

                            } catch (e) {
                                // If memory exceeds allowed usage, remove session data
                                // In modern browsers Session Storage is around 10MB
                                sessionStorage.removeItem('sessionData');
                            }
                        }
                    });
            } else {
                $('a.ss-ajax-load-more-btn').remove();
            }
        });
    }

    // Utility function for removing a parameter from URL
    function remove_param(url, parameter) {
        return url
            .replace(new RegExp('[?&]' + parameter + '=[^&#]*(#.*)?$'), '$1')
            .replace(new RegExp('([?&])' + parameter + '=[^&]*&'), '$1');
    }

    // Utility function for getting a parameter by name from URL
    // http://stackoverflow.com/questions/901115/how-can-i-get-query-string-values-in-javascript#answer-901144
    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search),
            val;
        if (results && results.length > 0) {
            val = decodeURIComponent(results[1].replace(/\+/g, " "));
        }
        val = val === '' ? "none" : val;
        return results === null ? false : val;
    }

    // Add support for yith quickview plugin on filtered results
    $(document).on('ss-wcaf-ajax-filtered ss-wcaf-ajax-loaded session-loaded', function () {
        if ($.fn.yith_quick_view) {
            $.fn.yith_quick_view();
        }
    });

    // Wrap side panel in an inner div
    $(ss_sb_container).wrapInner('<div class="panel-wrap"></div>');

    $('.panel-toggle, .panel-body-mask').click(function (e) {
        e.preventDefault();
        $(ss_sb_container).toggleClass('side-panel-active');
        $('.panel-body-mask').toggleClass('show-mask');
        $('#sliding-panel-actions').toggleClass('active-toggle');
    });

    if (matchMedia) {
        var mq = window.matchMedia("(max-width: 768px)");
        mq.addListener(sswcaf_width_change);
        sswcaf_width_change(mq);
    }

    // media query change
    function sswcaf_width_change(mq) {
        if (mq.matches) {
            $(ss_sb_container).addClass('sliding-sidebar');
            $('#sliding-panel-actions').addClass('show-actions');
            $('.panel-body-mask').removeClass('disable-mask');
        } else {
            $(ss_sb_container).removeClass('sliding-sidebar');
            $('#sliding-panel-actions').removeClass('show-actions');
            $('.panel-body-mask').addClass('disable-mask');
        }
    }
	
	$(document).on('ready ss-wcaf-ajax-filtered', function() {
		if($(window).width() < 768) {
			$(ss_sb_container).addClass('sliding-sidebar');
		}
	});
	
	$(document).on('ss-wcaf-ajax-filtered', function() {
		if($(window).width() < 768) {
			$(ss_sb_container).wrapInner('<div class="panel-wrap"></div>');
		}
	});	

}); //$