<?php
/**
 * Output a single payment method
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment-method.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.0
 * @fc-version  2.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Use output buffer to avoid invalid when `get_icon` function outputs the contents instead of returning it
ob_start();
$icon_html = $gateway->get_icon();
$icon_html_from_output = ob_get_clean();
$has_icon_classes = ( null !== $icon_html_from_output && ! empty( $icon_html_from_output ) ) || ( null !== $icon_html && ! empty( trim( $icon_html ) ) ) ? 'has-icon' : ''; // WPCS: XSS ok.
?>
<?php // CHANGE: Add class to detect when the list item has an icon ?>
<li class="wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?> <?php echo $has_icon_classes; // WPCS: XSS ok. ?>">
	<input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />

	<label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
        <?php // CHANGE: Add `span` element for the payment method label text and icon ?>
		<span class="payment-method__label-text"><?php echo $gateway->get_title(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?></span> <span class="payment-method__label-icon"><?php echo $gateway->get_icon(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?></span>
	</label>
	<?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
		<div class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>" <?php if ( ! $gateway->chosen ) : /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>style="display:none;"<?php endif; /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>>
			<?php $gateway->payment_fields(); ?>
		</div>
	<?php endif; ?>
</li>
